#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include "backend_client.h"

using namespace quasar;

BackendClient::BackendClient(const std::shared_ptr<ipc::IIpcFactory>& ipcFactory)
    : BackendClientCore([this](const std::string requestId, proto::BackendRequest req) {
        connector_->sendMessage(ipc::buildMessage([&](auto& message) {
            YIO_LOG_DEBUG("Requesting " << requestId << " " << req.url());
            message.set_request_id(TString(requestId));
            message.mutable_backend_request()->Swap(&req);
        }));
    })
    , connector_(ipcFactory->createIpcConnector("backend"))
    , timeoutsCheck_([this]() {
        checkTimeouts();
    }, std::chrono::seconds(1))
{
    connector_->setMessageHandler([this](const ipc::SharedMessage& message) {
        if (message->has_request_id() && message->has_backend_response()) {
            const auto& response = message->backend_response();
            YIO_LOG_DEBUG("Response received " << message->request_id() << " " << response.response_code() << ' ' << (response.has_error() ? response.error() : ""));
            handleResponse(message->request_id(), response);
        }
    });
    connector_->connectToService();
}
