#pragma once

#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/libs/http_client/i_simple_http_client.h>

#include <chrono>
#include <future>
#include <functional>

namespace quasar {
    class BackendClientCore: public ISimpleHttpClient {
    public:
        // (request_id, request);
        using Sender = std::function<void(const std::string&, proto::BackendRequest)>;
        using ResponsePromise = std::promise<HttpResponse>;

        struct TimedPromise {
            ResponsePromise promise;
            std::chrono::steady_clock::time_point requested;
        };

        BackendClientCore(Sender sender);
        ~BackendClientCore();

        void setTimeoutInterval(std::chrono::milliseconds timeout);
        void handleResponse(const std::string& requestId, const proto::BackendResponse& response);
        void checkTimeouts();

        HttpResponse get(std::string_view tag, const std::string& url, const Headers& headers) override;
        HttpResponse head(std::string_view tag, const std::string& url, const Headers& headers) override;
        HttpResponse post(std::string_view tag, const std::string& url, const std::string& data, const Headers& headers) override;

    private:
        std::mutex mutex_;
        Sender sender_;
        std::chrono::milliseconds timeoutInterval_;

        std::shared_ptr<TimedPromise> enqueue(proto::BackendRequest req);

        std::unordered_map<std::string, std::shared_ptr<TimedPromise>> pendingRequests_;
    };

} // namespace quasar
