#include "backend_client_factory.h"
#include "backend_client.h"

#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/json_utils/json_utils.h>

using namespace quasar;

BackendClientFactory::BackendClientFactory(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
{
    onSystemConfigUpdated(Json::Value());
}

std::shared_ptr<ISimpleHttpClient> BackendClientFactory::getBackendClient(const std::string& debugName) {
    if (legacy_) {
        auto result = std::make_shared<HttpClient>(debugName, device_);
        result->setTimeout(std::chrono::seconds(20));
        result->setRetriesCount(0);
        return result;
    }
    return std::make_shared<BackendClient>(ipcFactory_);
}

void BackendClientFactory::onSystemConfigUpdated(const Json::Value& sysCfg) {
    constexpr auto cfgName = "backendClient";
    try {
        if (!sysCfg.isObject() && sysCfg.isMember(cfgName)) {
            std::string mode = getString(sysCfg[cfgName], "mode");
            if (mode == "service") {
                legacy_ = false;
                return;
            }
            if (mode == "legacy") {
                legacy_ = true;
                return;
            }
        }
    } catch (...) {
    }
    const auto& cfg = device_->configuration()->getCommonConfig();
    legacy_ = !(cfg.isMember(cfgName) && tryGetString(cfg[cfgName], "mode", "legacy") == "service");
}
