#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/http_client/i_simple_http_client.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <json/json.h>

namespace quasar {
    /*! this factory creates ISimpleHttpClient to work with backend according according settings
     * "backendClient": { "mode" : "legacy" }
     * "backendClient": { "mode" : "service" }
     */
    class BackendClientFactory {
    public:
        BackendClientFactory(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        std::shared_ptr<ISimpleHttpClient> getBackendClient(const std::string& debugName);
        void onSystemConfigUpdated(const Json::Value& sysCfg);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::atomic_bool legacy_{true};
    };
} // namespace quasar
