#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/libs/delay_timings_policy/delay_timings_policy.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/ipc/i_server.h>
#include <yandex_io/protos/model_objects.pb.h>

#include "queued_backend.h"

namespace quasar {

    class BackendEndpoint {
    public:
        static const std::string SERVICE_NAME;

        BackendEndpoint(std::shared_ptr<YandexIO::IDevice> device,
                        std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                        std::shared_ptr<IAuthProvider> authProvider,
                        std::shared_ptr<IBackoffRetries> delayTimingsPolicy);

    private:
        void startBackendRequest(const proto::BackendRequest& request, QueuedBackend::ResponseCallback answerCb);

        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        QueuedBackend backendClient_;
        std::shared_ptr<ipc::IServer> server_;
    };
} // namespace quasar
