#include "backend_service.h"

#include <memory>

using namespace quasar;

BackendService::BackendService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider,
    std::shared_ptr<IBackoffRetries> delayTimingsPolicy)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
    , delayTimingsPolicy_(std::move(delayTimingsPolicy))
{
}

std::string BackendService::getServiceName() const {
    return BackendEndpoint::SERVICE_NAME;
}

void BackendService::start() {
    endpointPtr_ = std::make_unique<BackendEndpoint>(device_, ipcFactory_, authProvider_, delayTimingsPolicy_);
}
