#pragma once

#include <yandex_io/libs/http_client/i_simple_http_client.h>
#include <yandex_io/libs/threading/i_callback_queue.h>

#include <future>
#include <deque>

namespace quasar {

    // class for queued access to quasar backend over https
    class QueuedBackend {
    public:
        using Headers = ISimpleHttpClient::Headers;
        using HttpResponse = ISimpleHttpClient::HttpResponse;

        QueuedBackend(std::shared_ptr<ICallbackQueue> cbQueue, std::unique_ptr<ISimpleHttpClient> httpClient, const std::string& url);
        QueuedBackend(std::unique_ptr<ISimpleHttpClient> httpClient, const std::string& url);

        using ResponseCallback = std::function<void(const HttpResponse&, std::string)>; // response, errorString.

        // cbs will be called in cbQueue
        void getCb(std::string tag, const std::string& path, Headers headers, ResponseCallback cb);
        void postCb(std::string tag, const std::string& path, Headers headers, std::string data, ResponseCallback cb);

        std::shared_ptr<ISimpleHttpClient> makeHttpClientOverMe();
        std::string getPath(const std::string& url) const;
        void setBackendUrl(const std::string& newBackendUrl);

        struct RequestParams {
            std::string path; // path and post togethere is 'key'
            bool post{false};

            bool operator<(const RequestParams& params) const;
        };

    private:
        struct Payload {
            std::string tag;
            Headers headers;
            std::string data;
        };

        std::string getBackendUrl() const;
        void processFirstRequest();
        HttpResponse doRequest(const RequestParams& params, const Payload& payload);
        void forceProcessing();
        void enqueueCallbacks(HttpResponse response, std::string error, std::deque<ResponseCallback> callbacks);
        void enqueue(RequestParams req, Payload payload, ResponseCallback& cb);

        struct Clients {
            Payload payload;
            std::deque<ResponseCallback> callbacks;
        };
        using RequestsMap = std::map<RequestParams, std::shared_ptr<Clients>>;

        mutable std::mutex mutex_;
        std::string backendUrl_;
        std::unique_ptr<ISimpleHttpClient> httpClient_;
        RequestsMap requests_;
        std::atomic_bool processing_{false};
        std::deque<RequestsMap::iterator> requestsQueue_;
        std::shared_ptr<ICallbackQueue> cbQueue_;
    };

} // namespace quasar
