#include "callback_backend_config_observer.h"

#include <yandex_io/libs/json_utils/json_utils.h>

#include <util/system/yassert.h>

namespace YandexIO {

    CallbackBackendConfigObserver::CallbackBackendConfigObserver(std::set<std::string> configNames, Callback callback)
        : configNames_(std::move(configNames))
        , callback_(std::move(callback))
    {
        Y_VERIFY(callback_);
    }

    void CallbackBackendConfigObserver::onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) {
        if (!configNames_.contains(configName)) {
            return;
        }
        const auto optJson = quasar::tryParseJson(jsonConfigValue);
        if (!optJson) {
            return;
        }
        callback_(configName, *optJson);
    }

    void CallbackBackendConfigObserver::onBackendConfigHandleStatus(BackendConfigHandleStatus /*status*/) {
    }

} // namespace YandexIO
