#pragma once

#include <yandex_io/sdk/backend_config_observer.h>

#include <json/json.h>

#include <functional>
#include <set>
#include <string>

namespace YandexIO {

    class CallbackBackendConfigObserver: public YandexIO::BackendConfigObserver {
    public:
        using Callback = std::function<void(std::string_view configName, const Json::Value& json)>;

        CallbackBackendConfigObserver(std::set<std::string> configNames, Callback callback);

        void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
        void onBackendConfigHandleStatus(BackendConfigHandleStatus status) override;

    private:
        const std::set<std::string> configNames_;
        const Callback callback_;
    };

} // namespace YandexIO
