#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>
#include <string>
#include <string_view>

namespace YandexIO {
    class BluetoothBackendConfigListener: public BackendConfigObserver {
    public:
        explicit BluetoothBackendConfigListener(std::shared_ptr<Bluetooth> bluetoothImpl);

        void subscribeOnConfig(const std::shared_ptr<SDKInterface>& sdk);

        void onDeviceConfig(const std::string& configName, const std::string& jsonConfigValue) override;

    private:
        void updateDeviceName(std::string name);

        std::shared_ptr<Bluetooth> bluetoothImpl_;
    };
} // namespace YandexIO
