#pragma once

#include "i_brick_status_listener.h"

#include <yandex_io/modules/bluetooth/bluetooth_impl_proxy.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/sdk/brick_status_observer.h>

#include <list>
#include <memory>
#include <mutex>

namespace YandexIO {
    class BluetoothBrickStatusListener: public BrickStatusObserver {
    public:
        explicit BluetoothBrickStatusListener(std::shared_ptr<BluetoothImplProxy> bluetoothImpl);
        ~BluetoothBrickStatusListener();

        void addListener(std::weak_ptr<IBrickStatusListener> listener);

    protected:
        void onBrickStatusChanged(YandexIO::BrickStatus brickStatus, const std::string& brickStatusUrl, bool subscriptionMode) override;

    private:
        void notifyBrickStatusChanged(bool status);

        std::list<std::weak_ptr<IBrickStatusListener>> getBrickStatusListeners();

    private:
        quasar::Lifetime lifetime_;
        std::shared_ptr<BluetoothImplProxy> bluetoothImpl_;
        std::list<std::weak_ptr<IBrickStatusListener>> listeners_;
        mutable std::mutex mutex_;
    };
} // namespace YandexIO
