#include "bluetooth_controller.h"

using namespace YandexIO;

BluetoothController::BluetoothController(std::shared_ptr<Bluetooth> bluetooth)
    : bluetooth_(std::move(bluetooth))
{
}

void BluetoothController::setVisibility(bool discoverable, bool connectable) {
    bluetooth_->setVisibility(discoverable, connectable);
}

void BluetoothController::dropConnections() {
    bluetooth_->disconnectAll(Bluetooth::BtRole::ALL);
}

void BluetoothController::factoryReset() {
    bluetooth_->factoryReset();
}
