#include "bluetooth_factory_reset_event_listener.h"

using namespace YandexIO;

void BluetoothFactoryResetEventListener::addListener(std::weak_ptr<BluetoothObserver> listener) {
    std::scoped_lock guard(mutex_);
    listeners_.push_back(std::move(listener));
}

std::list<std::weak_ptr<BluetoothObserver>> BluetoothFactoryResetEventListener::getListeners() const {
    std::scoped_lock guard(mutex_);
    return listeners_;
}

void BluetoothFactoryResetEventListener::notifyFactoryResetComplete() {
    const auto listeners = getListeners();
    for (const auto& wlistener : listeners) {
        if (auto listener = wlistener.lock()) {
            listener->onFactoryResetComplete();
        }
    }
}

void BluetoothFactoryResetEventListener::onBaseEvent(Bluetooth::BaseEvent ev, const Bluetooth::EventResult& /*res*/) {
    if (ev == Bluetooth::BaseEvent::FACTORY_RESET) {
        notifyFactoryResetComplete();
    }
}

void BluetoothFactoryResetEventListener::onSourceEvent(Bluetooth::SourceEvent /*ev*/, const Bluetooth::EventResult& /*res*/) {
}

void BluetoothFactoryResetEventListener::onSinkEvent(Bluetooth::SinkEvent /*ev*/, const Bluetooth::EventResult& /*res*/) {
}
