#pragma once

#include <yandex_io/modules/bluetooth/bluetooth_observer/bluetooth_observer.h>
#include <yandex_io/modules/bluetooth/bluetooth_state_listener/i_bluetooth_state_listener.h>

#include <yandex_io/modules/voice_assistant_blocker/voice_assistant_blocker.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <list>
#include <memory>
#include <mutex>

namespace YandexIO {
    class BluetoothMediaEventListener: public Bluetooth::BluetoothEventListener {
    public:
        BluetoothMediaEventListener(std::shared_ptr<SDKInterface> sdk, bool blockAlice);

        void addBluetoothListener(std::weak_ptr<BluetoothObserver> listener);

        void addBluetoothStateListener(std::weak_ptr<IBluetoothStateListener> listener);

    protected:
        void onBaseEvent(Bluetooth::BaseEvent ev, const Bluetooth::EventResult& res) override;

        void onSourceEvent(Bluetooth::SourceEvent ev, const Bluetooth::EventResult& res) override;

        void onSinkEvent(Bluetooth::SinkEvent ev, const Bluetooth::EventResult& res) override;

    private:
        void notifySourceConnected(const std::string& networkAddr);
        void notifySourceDisconnected(const std::string& networkAddr);

        void notifyConnectedState(bool state);
        void notifyPlayingState(bool state);

        void blockAssistant();
        void unblockAssistant();

        std::list<std::weak_ptr<BluetoothObserver>> getBtListeners() const;
        std::list<std::weak_ptr<IBluetoothStateListener>> getBtStateListeners() const;

        size_t connectionsCounter_ = 0;
        const std::shared_ptr<SDKInterface> sdk_;
        std::list<std::weak_ptr<BluetoothObserver>> btListeners_;
        std::list<std::weak_ptr<IBluetoothStateListener>> btStateListeners_;

        const bool blockAlice_;
        VoiceAssistantBlocker aliceBlocker_;

        // addListener and events callback can be called from different threades
        mutable std::mutex mutex_;
    };
} // namespace YandexIO
