#pragma once

#include <yandex_io/modules/bluetooth/bluetooth_observer/bluetooth_observer.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/libs/threading/periodic_executor.h>

#include <list>
#include <memory>
#include <mutex>

namespace YandexIO {
    class BluetoothVisibilityEventListener: public Bluetooth::BluetoothEventListener {
    public:
        BluetoothVisibilityEventListener(std::weak_ptr<Bluetooth> bluetoohtImpl, std::optional<std::chrono::milliseconds> fallbackTimeout = std::nullopt);

        void addListener(std::weak_ptr<BluetoothObserver> listener);

        ~BluetoothVisibilityEventListener();

    protected:
        void onBaseEvent(Bluetooth::BaseEvent ev, const Bluetooth::EventResult& res) override;

        void onSourceEvent(Bluetooth::SourceEvent ev, const Bluetooth::EventResult& res) override;

        void onSinkEvent(Bluetooth::SinkEvent ev, const Bluetooth::EventResult& res) override;

    private:
        void notifyDiscoveryStart();
        void notifyDiscoveryStop();

        std::list<std::weak_ptr<BluetoothObserver>> getListeners() const;

        std::weak_ptr<Bluetooth> bluetoothImpl_;

        const std::optional<std::chrono::milliseconds> fallbackTimeout_;
        std::unique_ptr<quasar::PeriodicExecutor> discoveryFallbackManager_;

        std::list<std::weak_ptr<BluetoothObserver>> listeners_;
        mutable std::mutex mutex_;
    };
} // namespace YandexIO
