#include "bluetooth_volume_event_listener.h"

#include <cmath>

using namespace YandexIO;

void BluetoothVolumeEventListerner::addBluetoothListener(std::weak_ptr<BluetoothObserver> listener) {
    std::scoped_lock guard(mutex_);
    listeners_.push_back(std::move(listener));
}

std::list<std::weak_ptr<BluetoothObserver>> BluetoothVolumeEventListerner::getListeners() const {
    std::scoped_lock guard(mutex_);
    return listeners_;
}

void BluetoothVolumeEventListerner::notifyChangeVolumeAVRCP(int volumePercent) {
    const auto listeners = getListeners();
    for (const auto& wlistener : listeners) {
        if (auto listener = wlistener.lock()) {
            listener->onChangeVolumeAVRCP(volumePercent);
        }
    }
}

void BluetoothVolumeEventListerner::onBaseEvent(Bluetooth::BaseEvent /*ev*/, const Bluetooth::EventResult& /*res*/) {
}

void BluetoothVolumeEventListerner::onSourceEvent(Bluetooth::SourceEvent /*ev*/, const Bluetooth::EventResult& /*res*/) {
}

void BluetoothVolumeEventListerner::onSinkEvent(Bluetooth::SinkEvent ev, const Bluetooth::EventResult& res) {
    if (ev == Bluetooth::SinkEvent::AVRCP_IN && res.avrcpEvent == Bluetooth::AVRCP::CHANGE_VOLUME_ABS) {
        const int volumePercent = std::round(res.volumeAbs / 127.0 * 100);
        notifyChangeVolumeAVRCP(volumePercent);
    }
}
