#pragma once

#include <yandex_io/modules/bluetooth/bluetooth_observer/bluetooth_observer.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>

#include <list>
#include <memory>
#include <mutex>

namespace YandexIO {
    class BluetoothVolumeEventListerner: public Bluetooth::BluetoothEventListener {
    public:
        BluetoothVolumeEventListerner() = default;

        void addBluetoothListener(std::weak_ptr<BluetoothObserver> listener);

    protected:
        void onBaseEvent(Bluetooth::BaseEvent ev, const Bluetooth::EventResult& res) override;
        void onSourceEvent(Bluetooth::SourceEvent ev, const Bluetooth::EventResult& res) override;
        void onSinkEvent(Bluetooth::SinkEvent ev, const Bluetooth::EventResult& res) override;

    private:
        void notifyChangeVolumeAVRCP(int volumePercent);

        std::list<std::weak_ptr<BluetoothObserver>> getListeners() const;

        std::list<std::weak_ptr<BluetoothObserver>> listeners_;

        // addListener and events callback can be called from different threades
        mutable std::mutex mutex_;
    };

} // namespace YandexIO
