#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/libs/signals/signal.h>

#include <set>

namespace YandexIO {

    class BluetoothImplProxy: public Bluetooth {
    public:
        explicit BluetoothImplProxy(std::shared_ptr<Bluetooth> bluetoothImpl);
        ~BluetoothImplProxy();

        // Bluetooth
        int setName(const std::string& name) override;
        int scanNetworks() override;
        int stopScanNetworks() override;
        int disconnectAll(BtRole role) override;
        int pairWithSink(const BtNetwork& network) override;
        int setVisibility(bool isDiscoverable, bool isConnectable) override;
        int asSinkPlayNext(const BtNetwork& network) override;
        int asSinkPlayPrev(const BtNetwork& network) override;
        int asSinkPlayPause(const BtNetwork& network) override;
        int asSinkPlayStart(const BtNetwork& network) override;
        int asSinkSetVolumeAbs(int volume) override;
        int powerOn() override;
        int powerOff() override;
        void freeAudioFocus() override;
        void takeAudioFocus() override;
        PowerState getPowerState() const override;
        bool isAsSinkPlaying() const override;
        void factoryReset() override;

        void registerEventListener(const std::weak_ptr<BluetoothEventListener>& listener);

        void enableBluetooth(std::string_view block);
        bool isEnabled() const;
        void disableBluetooth(std::string_view block);
        std::set<std::string> blockers() const;
        quasar::ISignal<bool>& enabledChangedSignal();

    private:
        void discardIfDisabled(std::string_view eventName);
        void onSourceEvent(SourceEvent ev, const EventResult& res);
        void onSinkEvent(SinkEvent ev, const EventResult& res);

    private:
        class Listener;
        quasar::Lifetime lifetime_;
        std::shared_ptr<Bluetooth> bluetoothImpl_;
        std::shared_ptr<Listener> listener_;
        quasar::Signal<quasar::ISignal<bool>> enabledChangedSignal_;

        mutable std::mutex mutex_;
        std::set<std::string> blockers_;
    };

} // namespace YandexIO
