#pragma once

#include <yandex_io/modules/bluetooth/bluetooth_brick_status_listener/callback_brick_status_listener.h>

#include <yandex_io/libs/base/linux_timer.h>
#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/sdk/bluetooth_media_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>

namespace YandexIO {
    class BluetoothMediaListener: public BluetoothMediaObserver {
    public:
        explicit BluetoothMediaListener(std::shared_ptr<Bluetooth> bluetoothImpl);

        std::weak_ptr<IBrickStatusListener> getBrickStatusListener() const;

        void onBtPause() override;
        void onBtResume() override;
        void onBtNext() override;
        void onBtPrev(bool forced) override;
        void onBtTakeAudioFocus() override;
        void onBtFreeAudioFocus() override;

        void onBtDisconnectAll() override;

    private:
        bool bricked_ = false;
        std::shared_ptr<CallbackBrickStatusListener> brickStatusListener_;
        std::shared_ptr<Bluetooth> bluetoothImpl_;
        quasar::LinuxTimer prevTimer_;
    };
} // namespace YandexIO
