#pragma once

#include "bluetooth_impl_proxy.h"

#include <yandex_io/modules/bluetooth/bluetooth_backend_config_listener/bluetooth_backend_config_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_brick_status_listener/bluetooth_brick_status_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_controller/bluetooth_controller.h>
#include <yandex_io/modules/bluetooth/bluetooth_event_listener/bluetooth_factory_reset_event_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_event_listener/bluetooth_media_event_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_event_listener/bluetooth_visibility_event_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_event_listener/bluetooth_volume_event_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_media_listener/bluetooth_media_listener.h>
#include <yandex_io/modules/bluetooth/bluetooth_observer/bluetooth_observer.h>
#include <yandex_io/modules/bluetooth/bluetooth_sdk_state_observer/bluetooth_sdk_state_observer.h>
#include <yandex_io/modules/bluetooth/bluetooth_stream_out_manager/bluetooth_stream_out_directive_observer.h>
#include <yandex_io/modules/bluetooth/bluetooth_stream_out_manager/bluetooth_stream_out_manager.h>
#include <yandex_io/modules/bluetooth/bluetooth_telemetry/bluetooth_telemetry.h>
#include <yandex_io/modules/bluetooth/bluetooth_volume_manager_listener/bluetooth_volume_manager_listener.h>
#include <yandex_io/modules/bluetooth/device_mode_observer/bluetooth_mode_on_start_setup.h>
#include <yandex_io/modules/bluetooth/directive_observer/bluetooth_directive_observer.h>

#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>

namespace YandexIO {

    class BluetoothModule {
    public:
        struct Settings {
            bool blockAlice = false;
            bool powerOffByDirective = false;
            bool useDirectiveObserver = true;
            bool useBluetoothMediaListener = true;
            bool bluetoothOnStartSetup = false;
            bool useBackendConfigObserver = true;
            bool useBrickStateListener = true;
            int maxVolume = 10;

            std::shared_ptr<ITelemetry> telemetry;
            BluetoothTelemetry::TelemetrySettings telemetrySettings;

            std::optional<std::chrono::milliseconds> visibilityFallbackTimeout;
            bool useSteamOutManager = false;

            struct StreamOutManagerSettings {
                std::shared_ptr<IDevice> device;
                std::shared_ptr<quasar::IAuthProvider> authProvider;
                std::string backendUrl;
                std::string deviceID;
                std::string platform;
            };

            StreamOutManagerSettings streamOutManagerSettings;
        };

        BluetoothModule(std::shared_ptr<Bluetooth> bluetoothImpl,
                        std::shared_ptr<quasar::IStereoPairProvider> stereoPairProvider,
                        const std::shared_ptr<SDKInterface>& sdk,
                        const Settings& settings);
        ~BluetoothModule();

        void addBluetoothStateListener(std::weak_ptr<IBluetoothStateListener> listener);
        void addBluetoothListener(std::weak_ptr<BluetoothObserver> listener);

        std::shared_ptr<BluetoothVolumeManagerListener> getVolumeManagerListener() const;

        std::shared_ptr<BluetoothController> getBluetoothController() const;

    private:
        quasar::Lifetime lifetime_;
        const std::shared_ptr<BluetoothImplProxy> bluetoothImplProxy_;
        const std::shared_ptr<BluetoothController> bluetoothController_;
        const std::shared_ptr<quasar::IStereoPairProvider> stereoPairProvider_;

        std::shared_ptr<BluetoothBackendConfigListener> bluetoothBackendConfigListener_;
        std::shared_ptr<BluetoothBrickStatusListener> bluetoothBrickStatusListener_;
        std::shared_ptr<BluetoothFactoryResetEventListener> bluetoothFactoryResetEventListener_;
        std::shared_ptr<BluetoothMediaEventListener> bluetoothMediaEventListener_;
        std::shared_ptr<BluetoothVisibilityEventListener> bluetoothVisibilityEventListener_;
        std::shared_ptr<BluetoothVolumeEventListerner> bluetoothVolumeEventListerner_;
        std::shared_ptr<BluetoothMediaListener> bluetoothMediaListener_;
        std::shared_ptr<BluetoothVolumeManagerListener> bluetoothVolumeManagerListener_;
        std::shared_ptr<BluetoothModeOnStartSetup> bluetoothModeOnStartSetup_;
        std::shared_ptr<BluetoothDirectiveObserver> bluetoothDirectiveObserver_;
        std::shared_ptr<BluetoothStreamOutManager> bluetoothStreamOutManager_;
        std::shared_ptr<BluetoothStreamOutDirectiveObserver> bluetoothStreamOutDirectiveObserver_;
        std::shared_ptr<BluetoothSDKStateObserver> bluetoothSDKStateObserver_;
        std::shared_ptr<BluetoothTelemetry> bluetoothTelemetry_;
    };

} // namespace YandexIO
