#pragma once

#include <string>

namespace YandexIO {
    class BluetoothObserver {
    public:
        virtual void onDiscoveryStart() = 0;
        virtual void onDiscoveryStop() = 0;

        virtual void onSourceConnected(const std::string& btAddr) = 0;
        virtual void onSourceDisconnected(const std::string& btAddr) = 0;

        virtual void onChangeVolumeAVRCP(int volumePercent) = 0;

        virtual void onFactoryResetComplete() = 0;

        virtual ~BluetoothObserver();
    };

} // namespace YandexIO
