#include "bluetooth_sdk_state_observer.h"

using namespace YandexIO;

BluetoothSDKStateObserver::BluetoothSDKStateObserver(std::shared_ptr<SDKInterface> sdk)
    : sdk_(std::move(sdk))
{
}

void BluetoothSDKStateObserver::onSourceConnected(const std::string& /*btAddr*/) {
    if (configurationState_.load() == SDKState::ConfigurationState::CONFIGURING) {
        sdk_->stopSetupMode();
    }
}

void BluetoothSDKStateObserver::onSDKState(const SDKState& state) {
    configurationState_ = state.configurationState;
}
