#pragma once

#include <yandex_io/modules/bluetooth/bluetooth_observer/bluetooth_observer.h>

#include <yandex_io/sdk/sdk_interface.h>
#include <yandex_io/sdk/sdk_state_observer.h>

#include <atomic>
#include <memory>

namespace YandexIO {

    class BluetoothSDKStateObserver: public SDKStateObserver, public BluetoothObserver {
    public:
        explicit BluetoothSDKStateObserver(std::shared_ptr<SDKInterface> sdk);

    protected:
        void onDiscoveryStart() override {
        }
        void onDiscoveryStop() override {
        }

        void onSourceConnected(const std::string& btAddr) override;
        void onSourceDisconnected(const std::string& /*btAddr*/) override {
        }

        void onChangeVolumeAVRCP(int /*volumePercent*/) override {
        }

        void onFactoryResetComplete() override {
        }

        void onSDKState(const SDKState& state) override;

    private:
        const std::shared_ptr<SDKInterface> sdk_;

        std::atomic<SDKState::ConfigurationState> configurationState_{SDKState::ConfigurationState::UNKNOWN};
    };

} // namespace YandexIO
