#include "callback_bluetooth_state_listener.h"

#include <util/system/yassert.h>

using namespace YandexIO;

CallbackBluetoothStateListener::CallbackBluetoothStateListener(OnBluetoothPlayingStateChanges onBluetoothPlayingStateChanges, OnBluetoothConnectionStateChanges onBluetoothConnectionStateChanges)
    : onBluetoothPlayingStateChanges_(std::move(onBluetoothPlayingStateChanges))
    , onBluetoothConnectionStateChanges_(std::move(onBluetoothConnectionStateChanges))
{
    Y_VERIFY(onBluetoothPlayingStateChanges_);
    Y_VERIFY(onBluetoothConnectionStateChanges_);
}

void CallbackBluetoothStateListener::onBtConnected(bool state) {
    onBluetoothConnectionStateChanges_(state);
}

void CallbackBluetoothStateListener::onBtPlaying(bool state) {
    onBluetoothPlayingStateChanges_(state);
}
