#pragma once

#include "i_bluetooth_state_listener.h"

#include <yandex_io/modules/device_state/extended_device_state.h>

#include <functional>

namespace YandexIO {
    class CallbackBluetoothStateListener: public IBluetoothStateListener {
    public:
        using OnBluetoothConnectionStateChanges = std::function<void(bool)>;
        using OnBluetoothPlayingStateChanges = std::function<void(bool)>;
        CallbackBluetoothStateListener(OnBluetoothPlayingStateChanges onBluetoothPlayingStateChanges, OnBluetoothConnectionStateChanges onBluetoothConnectionStateChanges);

        void onBtConnected(bool state) override;
        void onBtPlaying(bool state) override;

    private:
        OnBluetoothPlayingStateChanges onBluetoothPlayingStateChanges_;
        OnBluetoothConnectionStateChanges onBluetoothConnectionStateChanges_;
    };
} // namespace YandexIO
