#include "bluetooth_stream_out_directive_observer.h"

#include <yandex_io/libs/base/directives.h>

using namespace YandexIO;

BluetoothStreamOutDirectiveObserver::BluetoothStreamOutDirectiveObserver(std::shared_ptr<BluetoothStreamOutManager> bluetoothStreamOutManager, std::shared_ptr<Bluetooth> bluetoothImpl)
    : bluetoothStreamOutManager_(std::move(bluetoothStreamOutManager))
    , bluetoothImpl_(std::move(bluetoothImpl))
{
}

void BluetoothStreamOutDirectiveObserver::onDirective(const std::string& name, const std::string& /*vinsRequestId*/, const std::string& /*jsonPayload*/) {
    if (name == quasar::Directives::START_BLUETOOTH) {
        if (bluetoothImpl_->getPowerState() == Bluetooth::PowerState::OFF) {
            bluetoothImpl_->powerOn();
        }
        bluetoothStreamOutManager_->runStreamOut();
    } else if (name == quasar::Directives::STOP_BLUETOOTH) {
        bluetoothStreamOutManager_->stopStreamOut();
    }
}
