#pragma once

#include "bluetooth_stream_out_manager.h"

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/sdk/directive_observer.h>

#include <memory>

namespace YandexIO {
    class BluetoothStreamOutDirectiveObserver: public DirectiveObserver {
    public:
        BluetoothStreamOutDirectiveObserver(std::shared_ptr<BluetoothStreamOutManager> bluetoothStreamOutManager, std::shared_ptr<Bluetooth> bluetoothImpl);

        void onDirective(const std::string& name, const std::string& vinsRequestId, const std::string& jsonPayload) override;

        ~BluetoothStreamOutDirectiveObserver() = default;

    private:
        std::shared_ptr<BluetoothStreamOutManager> bluetoothStreamOutManager_;
        std::shared_ptr<Bluetooth> bluetoothImpl_;
    };
} // namespace YandexIO
