#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <array>
#include <map>
#include <memory>

namespace YandexIO {

    struct BluetoothTask {
        enum class Task {
            BLUETOOTH_ON,
            BLUETOOTH_OFF,
            SCAN_NETWORKS,
            PAIR_WITH,
            DISCONNECT,
            RECONNECT, // better drop it
        };
        BluetoothTask() = default;
        BluetoothTask(Task _task)
            : task(_task)
                  {};

        Task task;
        Bluetooth::BtNetwork network_;
    };

    class TaskManager {
    public:
        ~TaskManager();

        BluetoothTask takeTask();

        bool hasTask() const;

        void addTask(const BluetoothTask& task);

        void waitTask() const;

    private:
        enum class TaskPriority {
            URGENT = 0,
            MAJOR = 1,
            MINOR = 2,
            VERY_MINOR = 3,
            LAST_PRIORITY
        };
        static const std::map<BluetoothTask::Task, TaskPriority> taskPriorityMap;

        mutable quasar::SteadyConditionVariable taskCondVar_;
        mutable std::mutex tasksMutex_;
        std::array<std::unique_ptr<BluetoothTask>, (int)TaskPriority::LAST_PRIORITY> tasks_;
    };

} // namespace YandexIO
