#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/threading/periodic_executor.h>

#include <memory>
#include <set>

namespace YandexIO {
    class BluetoothTelemetry: public Bluetooth::BluetoothEventListener {
    public:
        struct TelemetrySettings {
            std::chrono::seconds heartbeatPeriod = std::chrono::seconds(30);
            bool heartbeat = true;
            bool connections = true;
            bool power = true;
        };

        BluetoothTelemetry(std::shared_ptr<ITelemetry> telemetry, bool isBtOnAtStart, TelemetrySettings settings);

    protected:
        void onBaseEvent(Bluetooth::BaseEvent ev, const Bluetooth::EventResult& res) override;

        void onSourceEvent(Bluetooth::SourceEvent ev, const Bluetooth::EventResult& res) override;

        void onSinkEvent(Bluetooth::SinkEvent ev, const Bluetooth::EventResult& res) override;

    private:
        const std::shared_ptr<ITelemetry> telemetry_;
        std::set<std::string> connectedDevices_;
        std::unique_ptr<quasar::PeriodicExecutor> executor_;
        std::mutex mutex_;
        Bluetooth::TrackInfo trackInfo_;
        TelemetrySettings settings_;
    };
} // namespace YandexIO
