#include "bluetooth_volume_manager_listener.h"

#include <cmath>

using namespace YandexIO;

BluetoothVolumeManagerListener::BluetoothVolumeManagerListener(std::shared_ptr<Bluetooth> bluetoothImpl, int maxVolume)
    : bluetoothImpl_(std::move(bluetoothImpl))
    , maxVolume_(maxVolume)
{
}

void BluetoothVolumeManagerListener::onVolumeChange(
    int platformVolume, int /* aliceVolume */,
    bool /* isMuted */, const std::string& /* source */, bool setBtVolume) {
    if (setBtVolume) {
        const int targetVolume = std::round((float)platformVolume / maxVolume_ * 127);
        bluetoothImpl_->asSinkSetVolumeAbs(targetVolume);
    }
}
