#pragma once

#include <yandex_io/modules/volume_manager/base/i_volume_manager_listener.h>

#include <yandex_io/libs/bluetooth/bluetooth.h>

#include <memory>

namespace YandexIO {
    class BluetoothVolumeManagerListener: public IVolumeManagerListener {
    public:
        BluetoothVolumeManagerListener(std::shared_ptr<Bluetooth> bluetoothImpl, int maxVolume);

    protected:
        void onVolumeChange(int platformVolume, int aliceVolume, bool isMuted, const std::string& source, bool setBtVolume) override;

    private:
        std::shared_ptr<Bluetooth> bluetoothImpl_;
        const int maxVolume_;
    };
} // namespace YandexIO
