#include "bluetooth_mode_on_start_setup.h"

using namespace YandexIO;

BluetoothModeOnStartSetup::BluetoothModeOnStartSetup(std::shared_ptr<Bluetooth> bluetoothImpl)
    : bluetoothImpl_(std::move(bluetoothImpl))
{
}

void BluetoothModeOnStartSetup::onStartSetup(bool /*isFirstSetup*/) {
    if (bluetoothImpl_->getPowerState() == Bluetooth::PowerState::OFF) {
        bluetoothImpl_->powerOn();
    }
    bluetoothImpl_->asSinkPlayPause(Bluetooth::BtNetwork{});
    bluetoothImpl_->setVisibility(true, true);
}

void BluetoothModeOnStartSetup::onFinishSetup() {
    bluetoothImpl_->setVisibility(false, false);
}
