#include "bluetooth_directive_observer.h"

#include <yandex_io/libs/base/directives.h>

using namespace YandexIO;
using namespace quasar;

BluetoothDirectiveObserver::BluetoothDirectiveObserver(std::shared_ptr<Bluetooth> bluetoothImpl, bool powerOffByDirective)
    : bluetoothImpl_(std::move(bluetoothImpl))
    , powerOffByDirective_(powerOffByDirective)
{
}

void BluetoothDirectiveObserver::onDirective(const std::string& name, const std::string& /*vinsRequestId*/, const std::string& /*jsonPayload*/) {
    if (name == quasar::Directives::START_BLUETOOTH) {
        if (bluetoothImpl_->getPowerState() == Bluetooth::PowerState::OFF) {
            bluetoothImpl_->powerOn();
        }
        bluetoothImpl_->setVisibility(true, true);
    } else if (name == quasar::Directives::STOP_BLUETOOTH) {
        bluetoothImpl_->disconnectAll(Bluetooth::BtRole::ALL);
        bluetoothImpl_->setVisibility(false, false);
        if (powerOffByDirective_) {
            bluetoothImpl_->powerOff();
        }
    }
}
