#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/sdk/directive_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>

namespace YandexIO {

    class BluetoothDirectiveObserver: public DirectiveObserver {
    public:
        BluetoothDirectiveObserver(std::shared_ptr<Bluetooth> bluetoothImpl, bool powerOffByDirective_);
        void onDirective(const std::string& name, const std::string& vinsRequestId, const std::string& jsonPayload) override;

        ~BluetoothDirectiveObserver() = default;

    private:
        std::shared_ptr<Bluetooth> bluetoothImpl_;
        const bool powerOffByDirective_;
    };

} // namespace YandexIO
