#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>
#include <string>

namespace YandexIO {
    class BluetoothAndroid final: public Bluetooth {
    public:
        explicit BluetoothAndroid(std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory);

        ~BluetoothAndroid() = default;

        int scanNetworks() override;

        int powerOn() override;
        int powerOff() override;
        PowerState getPowerState() const override {
            return PowerState::ON;
        }

        bool isAsSinkPlaying() const override {
            return false;
        }

        int stopScanNetworks() override;

        int pairWithSink(const Bluetooth::BtNetwork& /*network*/) override;

        int setVisibility(bool isDiscoverable, bool isConnectable) override;

        int disconnectAll(BtRole /*role*/) override;

        int asSinkPlayNext(const Bluetooth::BtNetwork& /*network*/) override;

        int asSinkPlayPrev(const Bluetooth::BtNetwork& /*network*/) override;

        int asSinkPlayStart(const Bluetooth::BtNetwork& /*network*/) override;

        int asSinkPlayPause(const Bluetooth::BtNetwork& /*network*/) override;

        int asSinkSetVolumeAbs(int volume) override;

        void takeAudioFocus() override;

        void freeAudioFocus() override;

        int setName(const std::string& name) override;

        void factoryReset() override {
        }

    private:
        static constexpr const char* BLUETOOTH_NAME = "Bluetooth Android Connector";

        void handleBluetoothMessage(const quasar::ipc::SharedMessage& message);

        std::shared_ptr<quasar::ipc::IConnector> toBluetooth_;
    };
} // namespace YandexIO
