#include "util.h"

using namespace quasar;

namespace YandexIO {

    Bluetooth::BtRole convertRole(const proto::BluetoothNetwork::BluetoothRole& role) {
        switch (role) {
            case proto::BluetoothNetwork::BluetoothRole::BluetoothNetwork_BluetoothRole_NONE: {
                return Bluetooth::BtRole::UNKNOWN;
            }
            case proto::BluetoothNetwork::BluetoothRole::BluetoothNetwork_BluetoothRole_SOURCE: {
                return Bluetooth::BtRole::SOURCE;
            }
            case proto::BluetoothNetwork::BluetoothRole::BluetoothNetwork_BluetoothRole_SINK: {
                return Bluetooth::BtRole::SINK;
            }
            default:
                break;
        }
        return Bluetooth::BtRole::UNKNOWN;
    }

    Bluetooth::TrackInfo prepareTrackInfo(const proto::BluetoothTrackMetaInfo& trackMetaInfo) {
        Bluetooth::TrackInfo trackInfo;
        if (trackMetaInfo.has_title()) {
            trackInfo.title = trackMetaInfo.title();
        }
        if (trackMetaInfo.has_artist()) {
            trackInfo.artist = trackMetaInfo.artist();
        }
        if (trackMetaInfo.has_album()) {
            trackInfo.album = trackMetaInfo.album();
        }
        if (trackMetaInfo.has_genre()) {
            trackInfo.genre = trackMetaInfo.genre();
        }
        trackInfo.songLenMs = trackMetaInfo.song_len_ms();
        trackInfo.currPosMs = trackMetaInfo.curr_pos_ms();
        return trackInfo;
    }

    Bluetooth::AVRCP convertAVRCP(const proto::AVRCP& avrcp) {
        switch (avrcp) {
            case proto::AVRCP::PLAY_START:
                return Bluetooth::AVRCP::PLAY_START;
            case proto::AVRCP::PLAY_PAUSE:
                return Bluetooth::AVRCP::PLAY_PAUSE;
            case proto::AVRCP::PLAY_STOP:
                return Bluetooth::AVRCP::PLAY_STOP;
            case proto::AVRCP::PLAY_NEXT:
                return Bluetooth::AVRCP::PLAY_NEXT;
            case proto::AVRCP::PLAY_PREV:
                return Bluetooth::AVRCP::PLAY_PREV;
            default:
                return Bluetooth::AVRCP::NONE;
        }
    }

    std::string prepareBluetoothName(const std::string& prefix, const std::string& deviceId, size_t maxIdSize) {
        std::string name;
        if (deviceId.size() <= maxIdSize) {
            name = prefix + deviceId;
        } else {
            name = prefix + deviceId.substr(deviceId.size() - maxIdSize, maxIdSize);
        }
        return name;
    }

    Bluetooth::SinkEvent eventFromVisibility(bool discoverable, bool connectable) {
        Bluetooth::SinkEvent ev = Bluetooth::SinkEvent::NON_VISIBLE;
        if (discoverable && connectable) {
            ev = Bluetooth::SinkEvent::DISCOVERABLE_CONNECTABLE;
        } else if (discoverable) {
            ev = Bluetooth::SinkEvent::DISCOVERABLE;
        } else if (connectable) {
            ev = Bluetooth::SinkEvent::CONNECTABLE;
        }
        return ev;
    }

} // namespace YandexIO
