#pragma once

#include <yandex_io/libs/bluetooth/bluetooth.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <memory>
#include <string>

namespace YandexIO {

    std::string prepareBluetoothName(const std::string& prefix, const std::string& deviceId = "", size_t maxIdSize = 4);

    template <typename Bluetooth>
    std::shared_ptr<Bluetooth> createBluetooth(const std::string& prefix, const std::string& deviceId = "", size_t maxIdSize = 4) {
        return std::make_shared<Bluetooth>(prepareBluetoothName(prefix, deviceId, maxIdSize));
    }

    Bluetooth::BtRole convertRole(const quasar::proto::BluetoothNetwork::BluetoothRole& role);

    Bluetooth::TrackInfo prepareTrackInfo(const quasar::proto::BluetoothTrackMetaInfo& trackMetaInfo);

    Bluetooth::AVRCP convertAVRCP(const quasar::proto::AVRCP& avrcp);

    Bluetooth::SinkEvent eventFromVisibility(bool discoverable, bool connectable);

} // namespace YandexIO
