#include "button_multiple_click_handler.h"

class ButtonMultipleClickHandler::MultipleClickHandler {
    int requiredNumber_;
    int currentNumber_ = 0;
    std::function<void(std::chrono::milliseconds)> onClick_;
    std::function<void()> onMultipleClick_;
    std::chrono::milliseconds clickPeriod_;

    std::chrono::steady_clock::time_point lastReleasedTs_;

public:
    MultipleClickHandler(
        int number,
        std::function<void(std::chrono::milliseconds)> onClick,
        std::function<void()> onMultipleClick,
        std::chrono::milliseconds clickPeriod)
        : requiredNumber_(number)
        , onClick_(std::move(onClick))
        , onMultipleClick_(std::move(onMultipleClick))
        , clickPeriod_(clickPeriod)
    {
    }

    void onButtonReleased(std::chrono::milliseconds timeDiff);
};

void ButtonMultipleClickHandler::addMultipleClickHandler(
    int buttonIdx, int number,
    std::function<void(std::chrono::milliseconds)> onClick,
    std::function<void()> onMultipleClick,
    std::chrono::milliseconds clickPeriod) {
    handlers_[buttonIdx] = std::make_shared<MultipleClickHandler>(number, onClick, onMultipleClick, clickPeriod);
}

void ButtonMultipleClickHandler::buttonReleased(int buttonIdx, std::chrono::milliseconds timeDiff)
{
    handlers_[buttonIdx]->onButtonReleased(timeDiff);
}

void ButtonMultipleClickHandler::MultipleClickHandler::onButtonReleased(std::chrono::milliseconds timeDiff)
{
    const auto curTs = std::chrono::steady_clock::now();
    const auto diff = curTs - lastReleasedTs_;
    lastReleasedTs_ = curTs;
    // double or more clicks detected. More clicks will be ignored
    if (diff < clickPeriod_) {
        if (++currentNumber_ == requiredNumber_) {
            onMultipleClick_();
            currentNumber_ = 0;
            return;
        }
    } else {
        currentNumber_ = 1;
    }

    if (currentNumber_ == 1) {
        onClick_(timeDiff);
    }
}
