#pragma once

#include <yandex_io/modules/buttons/buttons.h>

#include <map>

class ButtonMultipleClickHandler final {
public:
    void addMultipleClickHandler(
        int buttonIdx,
        int number,
        std::function<void(std::chrono::milliseconds)> onClick,
        std::function<void()> onMultipleClick,
        std::chrono::milliseconds clickPeriod = std::chrono::milliseconds(350));

    void buttonReleased(int buttonIdx, std::chrono::milliseconds timeDiff);

private:
    class MultipleClickHandler;

    std::map<int, std::shared_ptr<MultipleClickHandler>> handlers_;
};
