#pragma once

#include <yandex_io/libs/threading/lifetime.h>
#include <yandex_io/libs/threading/unique_callback.h>

#include <chrono>
#include <set>

/**
 * Resolves multiple clicks on single button into events
 */
class ButtonEventResolver {
public:
    enum class Event {
        PRESSED,
        RELEASED,
        CLICK,
        CLICK_AND_PRESSED,        /// required maxClickLevel >= 2
        DOUBLE_CLICK,             ///
        DOUBLE_CLICK_AND_PRESSED, /// required maxClickLevel = 3
        TRIPLE_CLICK              ///
    };

    /**
     * @param buttonIdx        - Index of the handling button
     * @param callbackQueue    - Callback queue to work within
     * @param callbackFunction - Function to execute on resolved event
     * @param maxClickLevel    - From 1 to 3. Enables or disables DOUBLE and TRIPLE clicks
     * @param releaseTm        - timeout between press and release to resolve event
     * @param nextPressTm      - timeout between release and press to resolve event
     */
    ButtonEventResolver(int buttonIdx,
                        const std::shared_ptr<quasar::ICallbackQueue>& callbackQueue,
                        std::function<void(int, Event)> callbackFunction,
                        uint8_t maxClickLevel,
                        std::chrono::milliseconds releaseTm,
                        std::chrono::milliseconds nextPressTm);
    ~ButtonEventResolver();

    void buttonPressed();
    void buttonReleased();

private:
    void resolve();

    const int buttonIdx_;

    bool isPressed_ = false;
    std::optional<Event> suggestedEvent_;

    std::weak_ptr<quasar::ICallbackQueue> callbackQueue_;
    quasar::UniqueCallback uniqueCallback_;
    const std::function<void(int, Event)> callbackFunction_;
    quasar::Lifetime lifetime_;

    uint8_t maxClickLevel_;
    const std::chrono::milliseconds releaseTimeout_;
    const std::chrono::milliseconds nextPressTimeout_;
};
