#include "button_events_regulator.h"

#include <yandex_io/libs/logging/logging.h>

#include <util/system/yassert.h>

YIO_DEFINE_LOG_MODULE("buttons");

ButtonEventsRegulator::ButtonEventsRegulator(std::shared_ptr<IButtonEventsHandler> buttonEventsHandler)
    : buttonEventsHandler_(std::move(buttonEventsHandler))
{
    Y_VERIFY(buttonEventsHandler_);
}

void ButtonEventsRegulator::buttonPressed(IButtonEventsHandler::ButtonIdx buttonIdx)
{
    if (std::find(pressedButtons_.begin(), pressedButtons_.end(), buttonIdx) != pressedButtons_.end()) {
        YIO_LOG_WARN("Button is already pressed. ButtonIdx: " << buttonIdx);
        return;
    }

    pressedButtons_.push_back(buttonIdx);

    if (pressedButtons_.size() == 1) {
        YIO_LOG_INFO("Button pressed. ButtonIdx: " << buttonIdx);
        buttonEventsHandler_->buttonPressed(buttonIdx);
    }
}

void ButtonEventsRegulator::buttonReleased(IButtonEventsHandler::ButtonIdx buttonIdx)
{
    auto iter = std::find(pressedButtons_.begin(), pressedButtons_.end(), buttonIdx);
    if (iter == pressedButtons_.end()) {
        YIO_LOG_WARN("Button is already released. ButtonIdx: " << buttonIdx);
        return;
    }

    if (iter != pressedButtons_.begin()) {
        pressedButtons_.erase(iter);
        return;
    }

    YIO_LOG_INFO("Button released. ButtonIdx: " << buttonIdx);
    buttonEventsHandler_->buttonReleased(buttonIdx);
    pressedButtons_.erase(iter);

    if (!pressedButtons_.empty()) {
        YIO_LOG_INFO("Button pressed. ButtonIdx: " << pressedButtons_.front());
        buttonEventsHandler_->buttonPressed(pressedButtons_.front());
    }
}
