#pragma once

#include "i_button_events_handler.h"

#include <list>

/**
 * Transforms button events into disjoint sequence so that two buttons can not be pressed at the same time
 */
class ButtonEventsRegulator {
public:
    ButtonEventsRegulator(std::shared_ptr<IButtonEventsHandler> buttonEventsHandler);

    void buttonPressed(IButtonEventsHandler::ButtonIdx buttonIdx);
    void buttonReleased(IButtonEventsHandler::ButtonIdx buttonIdx);

private:
    std::list<IButtonEventsHandler::ButtonIdx> pressedButtons_;

    std::shared_ptr<IButtonEventsHandler> buttonEventsHandler_;
};
