#include "call_state_observer.h"

CallStateObserver::CallStateObserver(std::weak_ptr<YandexIO::IAudioInputController> controller)
    : controller_(std::move(controller))
{
}

void CallStateObserver::onSDKState(const YandexIO::SDKState& deviceState) {
    if (auto ptr = controller_.lock()) {
        bool hasCall = deviceState.callState.status != YandexIO::SDKState::CallState::Status::NOCALL;

        if (!hasCall_ && hasCall) {
            ptr->startCommunicationMode();
        }

        if (hasCall_ && !hasCall) {
            ptr->stopCommunicationMode();
        }

        hasCall_ = hasCall;
    }
}
