#pragma once

#include <yandex_io/sdk/clock_display_state.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <util/folder/path.h>

#include <mutex>
#include <vector>

class ClockDisplayStateHolder {
public:
    ClockDisplayStateHolder(TFsPath stateFilePath, std::shared_ptr<YandexIO::SDKInterface> sdk);

    YandexIO::ClockDisplayState getClockDisplayState() const;

    void setClockBehaviour(bool isClockOn, bool enabled, bool showClockDuringDnd);
    void setBrightness(double brightness);

    class Listener {
    public:
        virtual ~Listener() = default;
        virtual void onClockDisplayStateChanged(YandexIO::ClockDisplayState newState) = 0;
    };
    void addListener(std::weak_ptr<Listener> wlistener);

private:
    void saveStateAndReport(bool shouldLog) const;
    void saveState(bool shouldLog) const;

private:
    mutable std::mutex mutex_;
    const TFsPath stateFilePath_;
    YandexIO::ClockDisplayState state_;
    std::vector<std::weak_ptr<Listener>> listeners_;
    const std::shared_ptr<YandexIO::SDKInterface> sdk_;
};
