#include "callback_data_reset_state_listener.h"

#include <util/system/yassert.h>

namespace YandexIO {

    CallbackDataResetStateListener::CallbackDataResetStateListener(OnDataResetStateChanges onDataResetStateChanges)
        : onDataResetStateChanges_(std::move(onDataResetStateChanges))
    {
        Y_VERIFY(onDataResetStateChanges_);
    }

    void CallbackDataResetStateListener::onDataResetWaitConfirm() {
        onDataResetStateChanges_(ExtendedDeviceState::DataResetState::DATA_RESET_WAIT_CONFIRM);
    }

    void CallbackDataResetStateListener::onDataResetExecuting() {
        onDataResetStateChanges_(ExtendedDeviceState::DataResetState::DATA_RESET_IN_PROGRESS);
    }

    void CallbackDataResetStateListener::onDataResetCanceled() {
        onDataResetStateChanges_(ExtendedDeviceState::DataResetState::NONE);
    }

} // namespace YandexIO
