#pragma once

#include <yandex_io/modules/data_reset/i_data_reset_state_listener.h>

#include <yandex_io/modules/device_state/extended_device_state.h>

#include <functional>

namespace YandexIO {

    class CallbackDataResetStateListener: public IDataResetStateListener {
    public:
        using OnDataResetStateChanges = std::function<void(ExtendedDeviceState::DataResetState)>;
        explicit CallbackDataResetStateListener(OnDataResetStateChanges onDataResetStateChanges);

        void onDataResetWaitConfirm() override;
        void onDataResetExecuting() override;
        void onDataResetCanceled() override;

    private:
        OnDataResetStateChanges onDataResetStateChanges_;
    };

} // namespace YandexIO
