#include "data_reset_executor.h"

#include <yandex_io/libs/base/utils.h>

#include <cstdlib>
#include <stdexcept>
#include <tuple>

using namespace quasar;

namespace YandexIO {

    ScriptsDataResetExecutor::ScriptsDataResetExecutor(std::vector<std::string> scripts)
        : scripts_(std::move(scripts))
    {
        for (const auto& script : scripts_) {
            if (!fileExists(script)) {
                throw std::runtime_error("Script file doesn't exist: " + script);
            }
        }
    }

    void ScriptsDataResetExecutor::execute()
    {
        for (const auto& script : scripts_) {
            std::ignore = std::system(script.c_str());
        }
    }

} // namespace YandexIO
