#pragma once

#include <string>
#include <vector>

namespace YandexIO {

    class DataResetExecutor {
    public:
        virtual ~DataResetExecutor() = default;
        virtual void execute() = 0;
    };

    /**
     * @breif ScriptsVectorDataResetExecutor in execute method will use scripts one by one
     */
    class ScriptsDataResetExecutor: public DataResetExecutor {
    public:
        explicit ScriptsDataResetExecutor(std::vector<std::string> scripts);
        ~ScriptsDataResetExecutor() = default;
        void execute() override;

    private:
        const std::vector<std::string> scripts_;
    };

} // namespace YandexIO
