#pragma once

#include <yandex_io/modules/demo_mode/demo_item/demo_item.h>
#include <yandex_io/modules/demo_mode/demo_listener_interface/i_demo_mode_listener.h>
#include <yandex_io/modules/demo_mode/demo_provider_interface/i_demo_provider.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <util/folder/path.h>

#include <deque>
#include <list>
#include <memory>

class DemoConfigManager: public YandexIO::BackendConfigObserver, public IDemoProvider {
public:
    static constexpr const char* DEMO_MODE_CONFIG = "demoMode";
    static constexpr const char* DEMO_MODE_SOUND_URL = "demoModeUrl";
    static constexpr int DEFAULT_HTTP_TIMEOUT_MS = 60000;
    static constexpr int DEFAULT_HTTP_RETRIES = 3;

    DemoConfigManager(const Json::Value& config, std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<IDemoProvider> module);
    ~DemoConfigManager() = default;

    void subscribeToSystemConfig(YandexIO::SDKInterface& sdk);
    void prepareItems() override;

    std::deque<DemoItem> getAllDemoItems() const override;
    std::deque<DemoItem> getNextDemoItems() override;
    void updateDemoItems(const Json::Value& /*items*/) override {
    }
    Json::Value toJson() const override {
        return Json::Value();
    }
    std::optional<std::chrono::milliseconds> getPauseBetweenItems() const override;

    void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
    void updateConfig(const Json::Value& value);

    void addListener(std::weak_ptr<IDemoModeListener> listener);

private:
    bool updateModule(const Json::Value& value);
    static bool checkCachedFiles(const std::shared_ptr<IDemoProvider>& module);
    bool downloadDemoFiles(const std::shared_ptr<IDemoProvider>& module);
    void cleanCacheDirectory();
    static std::map<std::string, std::string> getFilesToDownload(const std::shared_ptr<IDemoProvider>& module);

    std::list<std::weak_ptr<IDemoModeListener>> getListeners() const;

    void notifyDemoModeReady();
    void notifyDemoModeError();

private:
    const std::shared_ptr<YandexIO::IDevice> device_;
    TFsPath cachePath_;
    const std::string configPath_;
    mutable std::mutex mutex_;
    mutable std::mutex listenerMutex_;
    int httpClientTimeoutMs_;
    int httpClientRetriesCount_;
    std::optional<std::chrono::milliseconds> pauseBetweenItemsMs_;
    std::shared_ptr<IDemoProvider> module_;
    std::list<std::weak_ptr<IDemoModeListener>> listeners_;
};
