#include "demo_item.h"

#include <yandex_io/libs/json_utils/json_utils.h>

DemoItem::DemoItem(const std::string& cachePath, const std::string& soundUrl, const Json::Value& animationConfig)
    : sound(cachePath, soundUrl)
{
    if (animationConfig != Json::nullValue) {
        animation.emplace(DemoAnimation(cachePath, animationConfig));
    }
}

Json::Value DemoItem::toJson() const {
    Json::Value result;
    result["sound"] = sound.url;

    if (animation.has_value()) {
        result["animation"]["in"] = animation->in.url;
        result["animation"]["loop"] = animation->loop.url;
        result["animation"]["out"] = animation->out.url;
    }

    return result;
}
